/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.domain;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

import lombok.Getter;
import lombok.Setter;

/**
 * Represents a header of Payment Data Message (before reported payees)
 */
@Getter @Setter
public class XmlPaymentDataMsg {
    private String messageRefId;
    private String corrMessageRefId;
    private String country;
    private String messageType;
    private String cesopVersion;
    private Integer reportingPeriod;
    private String reportingPspIdentifier;
    private String reportingPspIdentifierType;
    private String sendingPspIdentifier;
    private String sendingPspIdentifierType;
    private String sendingPspIdentifierOther;
    private LocalDateTime processedOn;
    private String vldMessageRefId;
    private List<XmlTypeAndValue> sendingPspNames = new ArrayList<>();
}
